package ru.yandex.calendar.frontend.caldav.proto.caldav;

import java.util.Set;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;

/**
 * @author dbrylev
 */
public class CaldavSupportedCalendarComponentSets extends AbstractDavProperty<Set<CaldavSupportedCalendarComponentSet>> {
    private final Set<CaldavSupportedCalendarComponentSet> sets;

    public CaldavSupportedCalendarComponentSets(ListF<ListF<String>> sets) {
        super(CaldavConstants.CALDAV_SUPPORTED_CALENDAR_COMPONENT_SETS_PROP, false);

        this.sets = sets.map(new Function<ListF<String>, CaldavSupportedCalendarComponentSet>() {
            public CaldavSupportedCalendarComponentSet apply(ListF<String> componentNames) {
                return new CaldavSupportedCalendarComponentSet(componentNames.toArray(String.class));
            }
        }).unique();
    }

    @Override
    public Set<CaldavSupportedCalendarComponentSet> getValue() {
        return sets;
    }
}
