package ru.yandex.calendar.frontend.caldav.proto.caldav;

import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
@SuppressWarnings("serial")
public class CaldavWithHttpStatusCodeException extends CaldavException {
    private final int statusCode;

    public int getStatusCode() {
        return statusCode;
    }

    public CaldavWithHttpStatusCodeException(int statusCode, String message) {
        super(message);
        Validate.isTrue(statusCode > 100);
        this.statusCode = statusCode;
    }

    public CaldavWithHttpStatusCodeException(int statusCode, String message, Throwable cause) {
        super(message, cause);
        Validate.isTrue(statusCode > 100);
        this.statusCode = statusCode;
    }

} //~
