package ru.yandex.calendar.frontend.caldav.proto.caldav;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
public class EmailProperty extends AbstractDavProperty<Email[]> {

    private final ListF<Email> emails;

    public EmailProperty(DavPropertyName name, ListF<Email> emails, boolean isInvisibleInAllprop) {
        super(name, isInvisibleInAllprop);
        this.emails = emails;
    }

    public EmailProperty(DavPropertyName name, Email email) {
        this(name, Cf.list(email), false);
    }

    @Override
    public Element toXml(Document document) {
        Element element = getName().toXml(document);

        for (Email email : emails) {
            Element emailElement = document.createElementNS(CaldavConstants.CALENDARSERVER_NS_URI, "email-address");
            emailElement.appendChild(document.createTextNode(Emails.getUnicoded(email)));
            element.appendChild(emailElement);
        }

        return element;
    }


    @Override
    public Email[] getValue() {
        return emails.toArray(Email.class);
    }

} //~
