package ru.yandex.calendar.frontend.caldav.proto.caldav;

import org.apache.jackrabbit.webdav.property.AbstractDavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.bolts.function.Function0;

/**
 * @url https://issues.apache.org/jira/browse/JCR-2750
 * @author Stepan Koltsov
 */
public class LazyDavProperty<T> extends AbstractDavProperty<T> {

    private final Function0<T> value;
    private T valueCached;

    public LazyDavProperty(DavPropertyName name, Function0<T> value, boolean isInvisibleInAllprop) {
        super(name, isInvisibleInAllprop);
        this.value = value;
    }

    @Override
    public T getValue() {
        if (valueCached == null) {
            valueCached = value.apply();
        }
        return valueCached;
    }

} //~
