package ru.yandex.calendar.frontend.caldav.proto.caldav.itip;

/**
 * @author Stepan Koltsov
 *
 * @url http://tools.ietf.org/html/rfc5546#section-3.6
 * @url http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-08#section-9.2
 */
public enum StatusCode {
    PENDING("1.0", "Message is pending"),
    SENT("1.1", "Message has been successfully sent"),
    DELIVERED("1.2", "Message has been successfully delivered"),

    SUCCESS("2.0", "Success"),
    SUCCESS_WITH_FALLBACK("2.1", "Success, but fallback taken"),
    SUCCESS_INVALID_PROPERTY_IGNORED("2.2", "Success; invalid property ignored"),
    SUCCESS_INVALID_PROPERTY_PARAM_IGNORED("2.3", "Success; invalid property parameter ignored"),
    SUCCESS_UNKNOWN_PROEPRTY_IGNORED("2.4", "Success; unknown, non-standard property ignored"),
    SUCCESS_UNKNOWN_PROPERTY_VALUE_IGNORED("2.5", "Success; unknown, non-standard property value ignored"),
    SUCCESS_INVALID_CALENDAR_COMPONENT_IGNORED("2.6", "Success; invalid calendar component ignored"),
    SUCCESS_FORWARDED_TO_USER("2.7", "Success; request forwarded to Calendar User"),
    SUCCESS_REPEATING_IGNORED("2.8", "Success; repeating event ignored"),
    SUCCESS_TRUNCATED_DTEND("2.9", "Success; truncated end date time"),
    SUCCESS_REPEATING_VTOTO_IGNORED("2.10", "Success; repeating VTODO ignored"),
    SUCCESS_UNBOUNDED_RRULE_CLIPPED("2.11", "Success; unbounded RRULE clipped"),

    INVALID_PROEPRTY_NAME("3.0", "Invalid property name"),
    INVALID_PROPERTY_VALUE("3.1", "Invalid property value"),
    INVALID_PROPERTY_PARAMETER("3.2", "Invalid property parameter"),
    INVALID_PROPERTY_PARAMETER_VALUE("3.3", "Invalid property parameter value"),
    INVALID_CALENDAR_COMPONENT_SEQUENCE("3.4", "Invalid calendar component sequence"),
    INVALIDATE_DATE_TIME("3.5", "Invalid date or time"),
    INVALID_RRULE("3.6", "Invalid rule"),
    INVALID_USER("3.7", "Invalid Calendar User"),
    INVALID_NO_AUTHORITY("3.8", "No authority"),
    UNSUPPORTED_VERSION("3.9", "Unsupported version"),
    REQUEST_ENTITY_TOO_LARGE("3.10", "Request entity too large"),
    REQUIRED_COMPONENT_OR_PROPERTY_MISSING("3.11", "Required component or property missing"),
    UNKNOWN_COMPONENT_OR_PROPERTY("3.12", "Unknown component or property found"),
    UNSUPPORTED_COMPONENT_OR_PROPERTY("3.13", "Unsupported component or property found"),
    UNSUPPORTED_CAPABILITY("3.14", "Unsupported capability"),

    EVENT_CONFLICT("4.0", "Event conflict"),

    REQUEST_NOT_SUPPORTED("5.0", "Request not supported"),
    SERVICE_UNAVAILABLE("5.1", "Service unavailable"),
    PERMANENT_FAILURE("5.2", "Invalid calendar service"),
    NO_SCHEDULING_SUPPORT_FOR_USER("5.3", "No scheduling support for user"),
    ;

    private final String code;
    private final String defaultMessage;

    private StatusCode(String code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    public String getCode() {
        return code;
    }

    public String getDefaultMessage() {
        return defaultMessage;
    }

} //~
