package ru.yandex.calendar.frontend.caldav.proto.caldav.report;

import ru.yandex.misc.lang.tsb.YandexToStringBuilder;

/**
 * @author Stepan Koltsov
 */
public abstract class CalendarComponentCondition {

    @Override
    public String toString() {
        return YandexToStringBuilder.reflectionToString(this);
    }

    public static class TimeRangeCondition extends CalendarComponentCondition {
        private final TimeRange timeRange;

        public TimeRangeCondition(TimeRange timeRange) {
            this.timeRange = timeRange;
        }

        public TimeRange getTimeRange() {
            return timeRange;
        }

        @Override
        public String toString() {
            return "TimeRangeCondition[" + timeRange + "]";
        }

    }

    public static class PropertyCondition extends CalendarComponentCondition {
        private final String propertyName;

        // no condition yet
        public PropertyCondition(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return propertyName;
        }
    }

} //~
