package ru.yandex.calendar.frontend.caldav.proto.caldav.report;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1B;

/**
 * @author gutman
 */
public abstract class CalendarComponentConditions {

    public abstract CalendarComponentCondition.TimeRangeCondition getTimeRangeCondition();

    public abstract ListF<CalendarComponentCondition.PropertyCondition> getPropertyConditions();

    public static CalendarComponentConditions all(ListF<CalendarComponentCondition> conditions) {
        return new All(conditions);
    }

    public static CalendarComponentConditions trueCondition() {
        return new All(Cf.<CalendarComponentCondition>list());
    }

    public static CalendarComponentConditions falseCondition() {
        return new False();
    }

    public boolean isFalse() {
        return this instanceof False;
    }

    private static class All extends CalendarComponentConditions {
        private final ListF<CalendarComponentCondition> conditions;

        public All(ListF<CalendarComponentCondition> conditions) {
            this.conditions = conditions;
        }

        @Override
        public CalendarComponentCondition.TimeRangeCondition getTimeRangeCondition() {
            for (CalendarComponentCondition condition : conditions) {
                if (condition instanceof CalendarComponentCondition.TimeRangeCondition) {
                    return (CalendarComponentCondition.TimeRangeCondition) condition;
                }
            }
            return new CalendarComponentCondition.TimeRangeCondition(TimeRange.unlimited());
        }

        @Override
        public ListF<CalendarComponentCondition.PropertyCondition> getPropertyConditions() {
            return conditions.filter(new Function1B<CalendarComponentCondition>() {
                public boolean apply(CalendarComponentCondition calendarComponentCondition) {
                    return calendarComponentCondition instanceof CalendarComponentCondition.PropertyCondition;
                }
            }).uncheckedCast();
        }
    }

    private static class False extends CalendarComponentConditions {

        @Override
        public CalendarComponentCondition.TimeRangeCondition getTimeRangeCondition() {
            throw new IllegalStateException("CalendarComponentConditions.False");
        }

        @Override
        public ListF<CalendarComponentCondition.PropertyCondition> getPropertyConditions() {
            throw new IllegalStateException("CalendarComponentConditions.False");
        }

    }

}
