package ru.yandex.calendar.frontend.caldav.proto.caldav.report;

import ru.yandex.bolts.collection.Option;

/**
 * @author gutman
 */
public class CalendarComponentsFilter {

    private final CalendarComponentConditions veventConditions;
    private final CalendarComponentConditions vtodoConditions;

    public CalendarComponentsFilter(Option<CalendarComponentConditions> veventCondition, Option<CalendarComponentConditions> vtodoConditions) {
        if (!veventCondition.isPresent() && !vtodoConditions.isPresent()) { // any
            this.veventConditions = CalendarComponentConditions.trueCondition();
            this.vtodoConditions = CalendarComponentConditions.trueCondition();
        } else {
            this.veventConditions = veventCondition.getOrElse(CalendarComponentConditions.falseCondition());
            this.vtodoConditions = vtodoConditions.getOrElse(CalendarComponentConditions.falseCondition());
        }
    }

    public static CalendarComponentsFilter any() {
        return new CalendarComponentsFilter(Option.<CalendarComponentConditions>empty(), Option.<CalendarComponentConditions>empty());
    }

    public CalendarComponentConditions getVeventConditions() {
        return veventConditions;
    }

    public CalendarComponentConditions getVtodoConditions() {
        return vtodoConditions;
    }

    public boolean includesVevents() {
        return !(veventConditions.isFalse());
    }

    public boolean includesVtodos() {
        return !(vtodoConditions.isFalse());
    }

}
