package ru.yandex.calendar.frontend.caldav.proto.caldav.report;

import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavHref;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequestParser;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestParser;
import ru.yandex.misc.xml.dom.DomUtils;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 *
 * @author Stepan Koltsov
 *
 */
public class ReportRequestCalendarParser {

    /**
     *          <!ELEMENT calendar-query ((DAV:allprop |
     *                               DAV:propname |
     *                               DAV:prop)?, filter, timezone?)>
     *
     * @url http://tools.ietf.org/html/rfc4791#section-9.5
     */
    public static ReportRequestCalendarQuery parseQuery(Element element) {
        DomUtils.validateName(element, Dom4jUtils.toJavaxXmlNamespaceQName(CaldavConstants.CALDAV_CALENDAR_QUERY_QNAME));

        PropertiesRequest propertiesRequest = PropertiesRequest.all();
        CalendarComponentsFilter calendarFilter = CalendarComponentsFilter.any();

        for (Element child : DomUtils.childElements(element)) {
            Option<PropertiesRequest> prop = PropertiesRequestParser.parseProp(child);
            if (prop.isPresent()) {
                propertiesRequest = prop.get();
            } else if (DomUtils.nameIs(child, Dom4jUtils.toJavaxXmlNamespaceQName(CaldavConstants.CALDAV_FILTER_QNAME))) {
                calendarFilter = ReportRequestParser.parseFilter(child);
            } else if (DomUtils.nameIs(child, Dom4jUtils.toJavaxXmlNamespaceQName(CaldavConstants.CALDAV_TIMEZONE_QNAME))) {
                ReportRequestParser.logger.warn(DomUtils.qname(child) + " param is ignored");
            } else {
                throw new IllegalArgumentException("unknown element: " + DomUtils.qname(child));
            }
        }

        return new ReportRequestCalendarQuery(propertiesRequest, calendarFilter);
    }

    public static ReportRequestCalendarMultiget parseMultiget(Element element) {
        DomUtils.validateName(element, Dom4jUtils.toJavaxXmlNamespaceQName(CaldavConstants.CALDAV_CALENDAR_MULTIGET_QNAME));

        PropertiesRequest propertiesRequest = PropertiesRequest.all();
        ListF<DavHref> hrefs = Cf.arrayList();

        for (Element child : DomUtils.childElements(element)) {
            Option<PropertiesRequest> prop = PropertiesRequestParser.parseProp(child);
            if (prop.isPresent()) {
                propertiesRequest = prop.get();
            } else if (DomUtils.nameIs(child, Dom4jUtils.toJavaxXmlNamespaceQName(WebdavConstants.DAV_HREF_QNAME))) {
                hrefs.add(ReportRequestParser.parseHref(child));
            } else {
                throw new IllegalArgumentException("unknown element: " + DomUtils.qname(child));
            }
        }

        return new ReportRequestCalendarMultiget(propertiesRequest, hrefs);
    }

} //~
