package ru.yandex.calendar.frontend.caldav.proto.caldav.report;

import java.util.Optional;

import lombok.Getter;
import lombok.ToString;

import ru.yandex.calendar.frontend.caldav.proto.webdav.DavSyncLevel;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavSyncToken;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequest;

/**
 * @url http://tools.ietf.org/html/rfc6578#section-6.1
 *
 *    <!ELEMENT sync-collection (sync-token, sync-level, limit?, prop)>
 *
 *    <!-- DAV:limit defined in RFC 5323, Section 5.17 -->
 *    <!-- DAV:prop defined in RFC 4918, Section 14.18 -->
 */
@Getter
@ToString
public class ReportRequestSyncCollection extends ReportRequestCalendar {
    private final DavSyncLevel syncLevel;
    private final DavSyncToken syncToken;
    private final Optional<Integer> limit; // How many records return in response - empty stands for no limits

    public ReportRequestSyncCollection(
            PropertiesRequest davPropertyNameSet, DavSyncToken syncToken, DavSyncLevel syncLevel,
            Optional<Integer> limit)
    {
        super(davPropertyNameSet);
        this.syncToken = syncToken;
        this.syncLevel = syncLevel;
        this.limit = limit;
    }
}
