package ru.yandex.calendar.frontend.caldav.proto.caldav.report;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.EventLoadLimits;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Stepan Koltsov
 */
public class TimeRange extends DefaultObject {
    private final Option<Instant> start;
    private final Option<Instant> end;

    public TimeRange(Option<Instant> start, Option<Instant> end) {
        this.start = start;
        this.end = end;
    }

    public Option<Instant> getStart() {
        return start;
    }

    public Option<Instant> getEnd() {
        return end;
    }

    @Override
    public String toString() {
        return "TimeRange[" + start + "," + end + "]";
    }

    public static TimeRange unlimited() {
        return new TimeRange(Option.<Instant>empty(), Option.<Instant>empty());
    }

    public static TimeRange start(Instant start) {
        return new TimeRange(Option.of(start), Option.<Instant>empty());
    }

    public EventLoadLimits toEventLoadLimits() {
        EventLoadLimits limits = EventLoadLimits.cons();

        if (start.isPresent()) limits = limits.withEndsInOrAfter(start.get());
        if (end.isPresent()) limits = limits.withStartsInOrBefore(end.get());

        return limits;
    }
} //~
