package ru.yandex.calendar.frontend.caldav.proto.caldav.schedule;

import org.dom4j.Element;

import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.caldav.itip.StatusCode;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 */
public class RequestStatus {
    private final StatusCode code;
    private final String message;

    public RequestStatus(StatusCode code, String message) {
        this.code = code;
        this.message = message;
    }

    public RequestStatus(StatusCode code) {
        this(code, code.getDefaultMessage());
    }

    public Element toXml() {
        Element element = Dom4jUtils.documentFactory().createElement(CaldavConstants.CALDAV_REQUEST_STATUS_QNAME);
        element.addText(code.getCode() + ";" + message);
        return element;
    }

} //~
