package ru.yandex.calendar.frontend.caldav.proto.caldav.schedule;

import org.dom4j.Element;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @url http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-08#section-14.1
 *
 * <pre>
 * Name:  schedule-response
 *
 * Namespace:  urn:ietf:params:xml:ns:caldav
 *
 * Purpose:  Contains the set of responses for a POST method request.
 *
 * Description:  See Section 7.3.
 *
 * Definition:
 *
 *     <!ELEMENT schedule-response (response*)>
 * </pre>
 *
 * @author Stepan Koltsov
 */
public class ScheduleResponse {
    private final ListF<ScheduleResponseItem> responses;

    public ScheduleResponse(ListF<ScheduleResponseItem> responses) {
        this.responses = responses;
    }

    public Element toXml() {
        Element element = Dom4jUtils.documentFactory().createElement(CaldavConstants.CALDAV_SCHEDULE_RESPONSE_QNAME);
        for (ScheduleResponseItem response : responses) {
            element.add(response.toXml());
        }
        return element;
    }
} //~
