package ru.yandex.calendar.frontend.caldav.proto.caldav.schedule;

import net.fortuna.ical4j.model.Calendar;
import org.dom4j.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function3;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @url http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-08#section-14.2
 *
 * <pre>
 * Name:  response
 *
 * Namespace:  urn:ietf:params:xml:ns:caldav
 *
 * Purpose:  Contains a single response for a POST method request.
 *
 * Description:  See Section 7.3.
 *
 * Definition:
 *
 * <!ELEMENT response (recipient,
 *                      request-status,
 *                      calendar-data?,
 *                      DAV:error?,
 *                      DAV:responsedescription?)>
 * </pre>
 *
 * @author Stepan Koltsov
 */
public class ScheduleResponseItem {
    private final Email recepient;
    private final RequestStatus status;
    private final Option<Calendar> calendarData;

    public ScheduleResponseItem(Email recepient, RequestStatus status, Option<Calendar> calendarData) {
        this.recepient = recepient;
        this.status = status;
        this.calendarData = calendarData;
    }

    public Element toXml() {
        Element element = Dom4jUtils.documentFactory().createElement(CaldavConstants.CALDAV_RESPONSE_QNAME);

        Element recepientE = element.addElement(CaldavConstants.CALDAV_RECEPIENT_QNAME);
        Element hrefE = recepientE.addElement(WebdavConstants.DAV_HREF_QNAME);
        hrefE.addText(Emails.getUnicodedMailto(recepient));

        element.add(status.toXml());

        if (calendarData.isPresent()) {
            Element calendarDataE = element.addElement(CaldavConstants.CALDAV_CALENDAR_DATA_QNAME);
            calendarDataE.addCDATA(calendarData.get().toString());
        }

        return element;
    }

    public static Function3<Email, RequestStatus, Option<Calendar>, ScheduleResponseItem> consF() {
        return new Function3<Email, RequestStatus, Option<Calendar>, ScheduleResponseItem>() {
            public ScheduleResponseItem apply(Email recepient, RequestStatus status, Option<Calendar> calendarData) {
                return new ScheduleResponseItem(recepient, status, calendarData);
            }
        };
    }

} //~
