package ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsVTimeZones;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsComponent;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVEvent;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVFreeBusy;
import ru.yandex.calendar.logic.ics.iv5j.ical.component.IcsVTimeZone;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsAttendee;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsDateTimePropertyBase;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsMethod;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author Stepan Koltsov
 */
public abstract class OutboxRequest {

    public static OutboxRequest parse(IcsCalendar calendar) {
        // What to do with timezone?
        ListF<IcsComponent> components = calendar.getComponents().filter(Function1B.instanceOfF(IcsVTimeZone.class).notF());
        Validate.V.sizeIs(1, components);
        if (components.single() instanceof IcsVFreeBusy) {
            Validate.V.equals(IcsMethod.REQUEST, calendar.getMethod());
            IcsVFreeBusy freeBusy = (IcsVFreeBusy) components.single();
            ListF<IcsAttendee> attendees = freeBusy.getAttendees();
            Validate.V.notEmpty(attendees);
            ListF<Email> emails = attendees.map(IcsAttendee.getEmailF());

            // XXX: left timezone
            IcsVTimeZones tzs = IcsVTimeZones.cons(calendar.getTimezones(), MoscowTime.TZ, false);
            Option<Instant> start = freeBusy.getDtStart().map(IcsDateTimePropertyBase.getInstantF(tzs));
            Option<Instant> end = freeBusy.getDtEnd().map(IcsDateTimePropertyBase.getInstantF(tzs));

            return new OutboxRequestVFreeBusy(emails, start, end);
        } else if (components.single() instanceof IcsVEvent) {
            IcsVEvent vevent = (IcsVEvent) components.single();

            ListF<Email> emails = vevent.getAttendees().map(IcsAttendee.getEmailF());
            return new OutboxRequestVEvent(vevent.getUid().get(), emails, calendar);
        } else {
            throw new IllegalArgumentException("unknown component: " + components.single());
        }

    }

} //~
