package ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.Validate;


/**
 * @author Stepan Koltsov
 */
public class OutboxRequestVEvent extends OutboxRequest {

    private final String uid;
    private final ListF<Email> attendees;
    private final IcsCalendar calendar;

    public OutboxRequestVEvent(String uid, ListF<Email> attendees, IcsCalendar calendar) {
        Validate.notEmpty(uid);
        Validate.notNull(calendar);
        this.uid = uid;
        this.attendees = attendees;
        this.calendar = calendar;
    }

    public String getUid() {
        return uid;
    }

    public ListF<Email> getAttendees() {
        return attendees;
    }

    public IcsCalendar getCalendar() {
        return calendar;
    }

} //~
