package ru.yandex.calendar.frontend.caldav.proto.carddav;

import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.dom4j.QName;

import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 * @see WebdavConstants
 * @see CaldavConstants
 */
public class CarddavConstants {

    public static final String CARDDAV_NS_URI = "urn:ietf:params:xml:ns:carddav";
    public static final Namespace CARDDAV_NS = Namespace.getNamespace("E", CARDDAV_NS_URI);

    /**
     * @see CaldavConstants#CALDAV_HOME_SET_PROP
     */
    public static final DavPropertyName CARDDAV_ADDRESSBOOK_HOME_SET_PROP    = DavPropertyName.create("addressbook-home-set", CARDDAV_NS);
    public static final DavPropertyName CARDDAV_PRINCIPAL_ADDRESS_PROP       = DavPropertyName.create("principal-address", CARDDAV_NS);
    public static final DavPropertyName CARDDAV_ADDRESSBOOK_DESCRIPTION_PROP = DavPropertyName.create("addressbook-description", CARDDAV_NS);
    public static final DavPropertyName CARDDAV_SUPPORTED_ADDRESS_DATA_PROP  = DavPropertyName.create("supported-address-data", CARDDAV_NS);
    public static final DavPropertyName CARDDAV_MAX_RESOURCE_SIZE_PROP       = DavPropertyName.create("max-resource-size", CARDDAV_NS);
    public static final DavPropertyName CARDDAV_ADDRESS_DATA_PROP            = DavPropertyName.create("address-data", CARDDAV_NS);
    public static final DavPropertyName CARDDAV_DIRECTORY_GATEWAY_PROP       = DavPropertyName.create("directory-gateway", CARDDAV_NS);

    public static final int CARDDAV_DIRECTORY_RT   = ResourceType.registerResourceType("directory",   CARDDAV_NS);
    public static final int CARDDAV_ADDRESSBOOK_RT = ResourceType.registerResourceType("addressbook", CARDDAV_NS);

    public static final QName CARDDAV_ADDRESSBOOK_MULTIGET_QNAME = Dom4jUtils.createQName("addressbook-multiget", CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_ADDRESSBOOK_QNAME          = Dom4jUtils.createQName("addressbook",          CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_ADDRESSBOOK_QUERY_QNAME    = Dom4jUtils.createQName("addressbook-query",    CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_ADDRESS_DATA_QNAME         = Dom4jUtils.createQName("address-data",         CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_ALLPROP_QNAME              = Dom4jUtils.createQName("allprop",              CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_FILTER_QNAME               = Dom4jUtils.createQName("filter",               CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_IS_NOT_DEFINED_QNAME       = Dom4jUtils.createQName("is-not-defined",       CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_LIMIT_QNAME                = Dom4jUtils.createQName("limit",                CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_NRESULTS_QNAME             = Dom4jUtils.createQName("nresults",             CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_PARAM_FILTER_QNAME         = Dom4jUtils.createQName("param-filter",         CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_PROP_FILTER_QNAME          = Dom4jUtils.createQName("prop-filter",          CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_PROP_QNAME                 = Dom4jUtils.createQName("prop",                 CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_SUPPORTED_COLLATION_QNAME  = Dom4jUtils.createQName("supported-collation",  CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());
    public static final QName CARDDAV_TEXT_MATCH_QNAME           = Dom4jUtils.createQName("text-match",           CARDDAV_NS.getPrefix(), CARDDAV_NS.getURI());

    public static final String ADDRESSBOOK_DAV = "addressbook";

} //~
