package ru.yandex.calendar.frontend.caldav.proto.carddav.report;

import org.w3c.dom.Element;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.ccdav.AddressbookSearchOperator;
import ru.yandex.misc.bender.annotation.BendingMethod;
import ru.yandex.misc.bender.annotation.GlobalPartName;

/**
 * @author Stepan Koltsov
 * @see ru.yandex.calendar.frontend.caldav.proto.caldav.report.CalendarComponentsFilter
 * @url http://tools.ietf.org/html/draft-ietf-vcarddav-carddav-10#section-10.5
 */
@GlobalPartName(name="filter", namespace=CarddavConstants.CARDDAV_NS_URI)
public class CardComponentFilter {
//    @XmlAttribute(name="test")
//    @DefaultValue("anyof")
    private final AddressbookSearchOperator addressbookSearchOperator;

    private final ListF<PropFilter> propFilters;

    public CardComponentFilter(AddressbookSearchOperator addressbookSearchOperator, ListF<PropFilter> propFilters) {
        this.addressbookSearchOperator = addressbookSearchOperator;
        this.propFilters = propFilters;
    }

    public AddressbookSearchOperator getOperator() {
        return addressbookSearchOperator;
    }

    public ListF<PropFilter> getPropFilters() {
        return propFilters;
    }

    @BendingMethod
    public static CardComponentFilter parse(Element element) {
        return ReportRequestAddressbookQueryParser.parseFilter(element);
    }

} //~
