package ru.yandex.calendar.frontend.caldav.proto.carddav.report;

import org.w3c.dom.Element;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.ccdav.AddressbookSearchOperator;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Stepan Koltsov
 * @url http://tools.ietf.org/html/draft-ietf-vcarddav-carddav-10#section-10.5.1
 */
public class PropFilter {
    private final String name;
    private final ListF<PropFilterPredicate> predicates;
    private final AddressbookSearchOperator addressbookSearchOperator;

    public PropFilter(String name, ListF<PropFilterPredicate> predicates, AddressbookSearchOperator addressbookSearchOperator) {
        this.name = name;
        this.predicates = predicates;
        this.addressbookSearchOperator = addressbookSearchOperator;
    }

    public String getName() {
        return name;
    }

    public ListF<PropFilterPredicate> getPredicates() {
        return predicates;
    }

    public AddressbookSearchOperator getOperator() {
        return addressbookSearchOperator;
    }

    @BenderPart
    public static PropFilter parse(Element element) {
        return ReportRequestAddressbookQueryParser.parsePropFilter(element);
    }

} //~
