package ru.yandex.calendar.frontend.caldav.proto.carddav.report;

import org.apache.commons.lang.NotImplementedException;
import org.w3c.dom.Element;

import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.bender.annotation.BendingMethod;
import ru.yandex.misc.bender.annotation.GlobalPartName;
import ru.yandex.misc.bender.annotation.XmlAttribute;
import ru.yandex.misc.bender.annotation.XmlText;

/**
 * @author Stepan Koltsov
 */
@BenderParseSubclasses({ PropFilterPredicate.TextMatch.class, PropFilterPredicate.ParamFilter.class })
public abstract class PropFilterPredicate {

    @GlobalPartName(name="text-match", namespace=CarddavConstants.CARDDAV_NS_URI)
    public static class TextMatch extends PropFilterPredicate {
        public enum MatchType {
            EQUALS,
            CONTAINS,
            STARTS_WITH,
            ENDS_WITH,
            ;

            private final String xmlValue;

            MatchType() {
                this.xmlValue = name().toLowerCase().replace("_", "-");
            }

            public static MatchType findByValue(String value) {
                for (MatchType matchType : values()) {
                    if (matchType.xmlValue.equals(value))
                        return matchType;
                }
                throw new IllegalArgumentException("unknown MatchType value: " + value);
            }
        }

        private final String text;
        private final String collation;
        private final boolean positive;
        private final MatchType matchType;

        public TextMatch(String text, String collation, boolean positive, MatchType matchType) {
            this.text = text;
            this.collation = collation;
            this.positive = positive;
            this.matchType = matchType;
        }

        public static TextMatch parseElement(
                @XmlText String text,
                @XmlAttribute(name="collation")        @BenderDefaultValue("i;unicode-casemap") String collation,
                @XmlAttribute(name="negate-condition") @BenderDefaultValue("no")                String negateCondition,
                @XmlAttribute(name="match-type")       @BenderDefaultValue("contains")          String matchTypeValue
            )
        {
            boolean positive = negateCondition.equals("no");
            MatchType matchType = MatchType.findByValue(matchTypeValue);
            return new TextMatch(text, collation, positive, matchType);
        }

        public String getText() {
            return text;
        }

        public String getCollation() {
            return collation;
        }

        public boolean isPositive() {
            return positive;
        }

        public MatchType getMatchType() {
            return matchType;
        }
    }

    @GlobalPartName(name="param-filter", namespace=CarddavConstants.CARDDAV_NS_URI)
    public static class ParamFilter extends PropFilterPredicate {

        // XXX: add params
        @BendingMethod
        public static ParamFilter parseElement(Element e) {
            throw new NotImplementedException();
        }
    }
}
