package ru.yandex.calendar.frontend.caldav.proto.carddav.report;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.caldav.report.ReportRequestCalendarMultiget;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavHref;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestMultiget;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestMultigetUtils;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.GlobalPartName;

/**
 * @author Stepan Koltsov
 * @see ReportRequestCalendarMultiget
 */
@Bendable
public class ReportRequestAddressbookMultiget extends ReportRequest implements ReportRequestMultiget {

    private final ListF<DavHref> hrefs;
    private final PropertiesRequest propertiesRequest;

    @GlobalPartName(name="addressbook-multiget", namespace=CarddavConstants.CARDDAV_NS_URI)
    public ReportRequestAddressbookMultiget(
            // XXX: temp, must use global name
            @BenderPart(name = WebdavConstants.DAV_HREF_NAME, namespace = WebdavConstants.DAV_NS_URI) ListF<DavHref> hrefs,
            @BenderPart PropertiesRequest propertiesRequest) {
        this.hrefs = hrefs;
        this.propertiesRequest = propertiesRequest;
    }

    public ListF<DavHref> getHrefs() {
        return hrefs;
    }

    public PropertiesRequest getPropertiesRequest() {
        return propertiesRequest;
    }

    @Override
    public String toString() {
        return ReportRequestMultigetUtils.toString(this);
    }

} //~
