package ru.yandex.calendar.frontend.caldav.proto.carddav.report;

import ru.yandex.calendar.frontend.caldav.proto.caldav.report.ReportRequestCalendarQuery;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequest;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.GlobalPartName;

/**
 * @author Stepan Koltsov
 *
 * @see ReportRequestCalendarQuery
 * @url http://tools.ietf.org/html/draft-ietf-vcarddav-carddav-10#section-10.3
 * <pre>
 *  <!ELEMENT addressbook-query ((DAV:allprop |
 *                                DAV:propname |
 *                                DAV:prop)?, filter, limit?)>
 * </pre>
 */
@GlobalPartName(name="addressbook-query", namespace=CarddavConstants.CARDDAV_NS_URI)
public class ReportRequestAddressbookQuery extends ReportRequest {
    @BenderPart
    private final PropertiesRequest propertiesRequest;
    @BenderPart
    private final CardComponentFilter cardComponentFilter;
    // XXX: add limit field

    public ReportRequestAddressbookQuery(PropertiesRequest propertiesRequest, CardComponentFilter cardComponentFilter) {
        this.propertiesRequest = propertiesRequest;
        this.cardComponentFilter = cardComponentFilter;
    }

    public PropertiesRequest getPropertiesRequest() {
        return propertiesRequest;
    }

    public CardComponentFilter getCardComponentFilter() {
        return cardComponentFilter;
    }

} //~
