package ru.yandex.calendar.frontend.caldav.proto.carddav.report;

import org.dom4j.QName;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.ccdav.AddressbookSearchOperator;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestParser;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.BenderXmlParser;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.xml.dom.DomUtils;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 *
 * @see ReportRequestParser
 */
public class ReportRequestAddressbookQueryParser {

    private static BenderParser<ReportRequestAddressbookQuery> addressbookQueryParser =
            Bender.parser(ReportRequestAddressbookQuery.class);

    public static ReportRequestAddressbookQuery parse(Element element) {
        return addressbookQueryParser.parseXml(element);
    }

    /**
     * XXX: rewrite using MXP
     * <pre>
     * <!ELEMENT filter (prop-filter*)>
     *
     * <!ATTLIST filter test (anyof | allof) "anyof">
     * </pre>
     *
     */
    public static CardComponentFilter parseFilter(Element element) {
        validateName(element, CarddavConstants.CARDDAV_FILTER_QNAME);

        final AddressbookSearchOperator addressbookSearchOperator;

        addressbookSearchOperator = parseOperator(element);

        ListF<PropFilter> propFilters = DomUtils.childElements(element, Dom4jUtils.toJavaxXmlNamespaceQName(CarddavConstants.CARDDAV_PROP_FILTER_QNAME)).map(new Function<Element, PropFilter>() {
            public PropFilter apply(Element element) {
                return parsePropFilter(element);
            }
        });

        return new CardComponentFilter(addressbookSearchOperator, propFilters);
    }

    private static AddressbookSearchOperator parseOperator(Element element) {
        String value = element.getAttribute("test");
        if (value.isEmpty()) {
            return AddressbookSearchOperator.ANYOF; // lame default value according to spec
        } else if (value.equals("anyof")) {
            return AddressbookSearchOperator.ANYOF;
        } else if (value.equals("allof")) {
            return AddressbookSearchOperator.ALLOF;
        } else {
            throw new IllegalArgumentException("unknown operator attribute value: '" + value + "'");
        }
    }

    /**
     * XXX: rewrite using MXP
     * <pre>
     * <!ELEMENT prop-filter (is-not-defined |
     *                         (text-match*, param-filter*))>
     *
     * <!ATTLIST prop-filter name CDATA #REQUIRED
     *                       test (anyof | allof) "anyof">
     * </pre>
     */
    public static PropFilter parsePropFilter(Element element) {
        validateName(element, CarddavConstants.CARDDAV_PROP_FILTER_QNAME);
        AddressbookSearchOperator addressbookSearchOperator = parseOperator(element);
        ListF<PropFilterPredicate> predicates = DomUtils.childElements(element).map(new Function<Element, PropFilterPredicate>() {
            public PropFilterPredicate apply(Element element) {
                return parsePredicate(element);
            }
        });
        String name = element.getAttribute("name");
        return new PropFilter(name, predicates, addressbookSearchOperator);
    }

    private static void validateName(Element element, QName qName) {
        Validate.isTrue(Dom4jUtils.sameQName(
                Dom4jUtils.createQName(element.getLocalName(), element.getPrefix(), element.getNamespaceURI()),
                qName));
    }

    private static final BenderXmlParser<PropFilterPredicate> propFilterPredicateParser = Bender.xmlParser(PropFilterPredicate.class);

    private static PropFilterPredicate parsePredicate(Element element) {
        return propFilterPredicateParser.parseXml(element);
    }

} //~
