package ru.yandex.calendar.frontend.caldav.proto.ccdav;

import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.dom4j.QName;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.ETag;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.userAgent.UserAgentType;
import ru.yandex.calendar.logic.contact.directory.DirectoryEntry;
import ru.yandex.calendar.logic.contact.directory.DirectoryEntryType;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsCuType;

/**
 * @author Stepan Koltsov
 */
public class CcDavUtils {

    /**
     * Calendar and Contact server seems to return both CalDAV and CardDAV constants in all requests. So do we.
     *
     * @url http://wiki.yandex-team.ru/calendar/re/caldav/calendarserver
     */
    public static String complianceClass(UserAgentType userAgentType) {
        // unset properties
        new String[] {
                // Unknown purpose list
                WebdavConstants.DAV_ACCESS_CONTROL_DAV,
                CaldavConstants.INBOX_AVAILABILITY_DAV,

                // Not implemented list
                CaldavConstants.CALENDARSERVER_PRIVATE_EVENTS_DAV,
                CaldavConstants.CALENDARSERVER_SHARING_DAV,
                CaldavConstants.CALENDARSERVER_SHARING_NO_SCHEDULING_DAV,
        }.toString();

        ListF<String> complianceClass = Cf.list(
                DavCompliance._1_,
                CarddavConstants.ADDRESSBOOK_DAV,
                CaldavConstants.CALENDAR_ACCESS_DAV,
                CaldavConstants.CALENDAR_AUTO_SCHEDULE_DAV,
                CaldavConstants.CALENDAR_AVAILABILITY_DAV,
                CaldavConstants.CALENDAR_SCHEDULE_DAV,
                CaldavConstants.CALENDAR_PROXY_DAV,
                CaldavConstants.CALENDARSERVER_PRIVATE_COMMENTS_DAV
        );

        if (userAgentType != UserAgentType.IPHONE) { // enabling principal search hangs iPhone
            complianceClass = complianceClass.plus(CaldavConstants.CALENDARSERVER_PRINCIPAL_PROPERTY_SEARCH_DAV);
        }

        return DavCompliance.concatComplianceClasses(complianceClass.toArray(String.class));
    }

    public static IcsCuType directoryEntryTypeToIcsCuType(DirectoryEntry directoryEntry, UserAgentType userAgent) {

        if (directoryEntry.getType() == DirectoryEntryType.PERSON) {
            return IcsCuType.INDIVIDUAL;
        }

        if (directoryEntry.getType() == DirectoryEntryType.CONF_ROOM) {
            if (userAgent == UserAgentType.ICAL) {
                return IcsCuType.INDIVIDUAL; // iCal ignores rooms in search suggest
            } else {
                return IcsCuType.ROOM;
            }
        }

        throw new IllegalArgumentException();
    }

    private final static QName[] SUPPORTED_REPORTS = new QName[] {
            WebdavConstants.DAV_EXPAND_PROPERTY_QNAME,
            WebdavConstants.DAV_SYNC_COLLECTION_QNAME,
            CaldavConstants.CALDAV_CALENDAR_QUERY_QNAME,
            CaldavConstants.CALDAV_CALENDAR_MULTIGET_QNAME,
            CarddavConstants.CARDDAV_ADDRESSBOOK_QUERY_QNAME,
            CarddavConstants.CARDDAV_ADDRESSBOOK_MULTIGET_QNAME
    };

    private final static QName[] UNSUPPORTED_REPORTS = new QName[] {
            WebdavConstants.DAV_ACL_PRINCIPAL_PROP_SET_QNAME,
            WebdavConstants.DAV_PRINCIPAL_MATCH_QNAME,
            WebdavConstants.DAV_PRINCIPAL_PROPERTY_SEARCH_QNAME,
            CaldavConstants.CALDAV_FREE_BUSY_QUERY_QNAME
    };

    private static final QName[] SUPPORTED_REPORTS_WITHOUT_SYNC_REPORT = Cf.x(SUPPORTED_REPORTS)
            .filter(Cf.Object.equalsF(WebdavConstants.DAV_SYNC_COLLECTION_QNAME).notF()).toArray(QName.class);


    // XXX find a better place for this
    public static QName[] getSupportedReports() {
        return SUPPORTED_REPORTS;
    }

    public static QName[] getSupportedReportsWithoutSyncReport() {
        return SUPPORTED_REPORTS_WITHOUT_SYNC_REPORT;
    }

    public static Option<ETag> getIfMatchETag(InputContext inputContext) {
        String etag = inputContext.getProperty("If-Match");

        if (etag != null && etag.endsWith("--gzip")) {
            etag = etag.substring(0, etag.length() - 6);
        }
        return etag != null ? Option.of(new ETag(etag)) : Option.empty();
    }

} //~
