package ru.yandex.calendar.frontend.caldav.proto.facade;

import java.util.List;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.ETag;
import ru.yandex.calendar.frontend.caldav.proto.caldav.report.CalendarComponentConditions;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.ScheduleResponse;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox.OutboxRequestVEvent;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox.OutboxRequestVFreeBusy;
import ru.yandex.calendar.frontend.caldav.proto.tree.CollectionId;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavSyncToken;
import ru.yandex.calendar.frontend.caldav.userAgent.UserAgentType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 * @see CarddavCalendarFacade
 * @see CcCalendarFacade
 */
public interface CaldavCalendarFacade {

    ListF<CalendarDescription> getUserOwnCalendars(PassportUid passportUid);

    ListF<CalendarDescription>  getUserOwnCalendarsSharedToClient(PassportUid ownerUid, PassportUid clientUid);

    ListF<CalendarDescription> getUserVisibleExternalCalendars(PassportUid passportUid);

    Email getUserEmail(String user);

    CalendarDescription getUserCalendar(PassportUid clientPassportUid, CollectionId collectionId);

    void changeCalendar(PassportUid clientPassportUid, CollectionId collectionId, CalendarProperties properties);

    void makeCalendar(PassportUid userUid, String id, ListF<String> componentNames, CalendarProperties properties);

    void removeCalendar(PassportUid clientPassportUid, CollectionId collectionId);

    void moveUserCalendarEvent(PassportUid clientPassportUid, CollectionId source, CollectionId destination, String fileName);

    Option<Long> getDefaultUserLayerId(PassportUid userUid);

    boolean existsCalendarWithId(CollectionId collectionId);

    ListF<CalendarComponent> getUserCalendarEvents(PassportUid clientUid, CollectionId collectionId,
            CalendarComponentConditions veventConditions, CalendarComponentConditions vtodoConditions,
            boolean includeIcs, UserAgentType userAgent);

    ListF<ComponentGetResult> getUserCalendarEvents(PassportUid clientUid, CollectionId collectionId,
            ListF<String> fileNames, boolean includeIcs, UserAgentType userAgent);

    /** none if not found */
    Option<CalendarComponent> getUserCalendarEvent(PassportUid clientUid, CollectionId collectionId,
            String fileName, boolean includeIcs, UserAgentType userAgent);

    void removeUserCalendarEvent(PassportUid clientUid, CollectionId collectionId, String fileName);

    void putUserCalendarEvent(PassportUid clientUid, CollectionId collectionId, String fileName, Option<ETag> eTag, byte[] calendar);

    ScheduleResponse notifyAttendees(PassportUid user, OutboxRequestVEvent req, PassportUid client, ListF<Email> recipients);

    ScheduleResponse getFreeBusy(PassportUid userUid, OutboxRequestVFreeBusy request, PassportUid clientUid);

    DavSyncToken getUserSyncToken(PassportUid userUid);

    DavSyncToken getCalendarSyncToken(CollectionId collectionId);

    List<ComponentModified> getUserCalendarModifiedEvents(PassportUid clientUid, CollectionId collectionId,
                                                          DavSyncToken syncToken, boolean includeIcs, UserAgentType userAgent);

    PassportUid checkAndGetPassportUid(String user);

} //~
