package ru.yandex.calendar.frontend.caldav.proto.facade;

import java.util.List;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.caldav.report.CalendarComponentConditions;
import ru.yandex.calendar.frontend.caldav.proto.tree.CollectionId;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavSyncToken;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.user.UserInfo;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Daniel Brylev
 */
public interface CaldavCalendarFacadeProvider {

    boolean existsCalendarWithId(CollectionId collectionId);

    void makeCalendarIfUserHasNoOne(UserInfo userInfo);

    ListF<CalendarDescription> getOwnCalendars(UserInfo userInfo);

    ListF<CalendarDescription> getCalendarsSharedByAnotherUser(UserInfo userInfo, PassportUid owner);

    ListF<CalendarDescription> getVisibleExternalCalendars(UserInfo userInfo);

    CalendarDescription getCalendarById(UserInfo userInfo, CollectionId collectionId);

    DavSyncToken getCalendarSyncToken(CollectionId collectionId);

    void makeCalendar(UserInfo userInfo, String id, CalendarProperties properties);

    void changeCalendar(UserInfo userInfo, CollectionId collectionId, CalendarProperties properties);

    void removeCalendar(UserInfo userInfo, CollectionId collectionId);

    void putCalendarEntry(
            UserInfo userInfo, IcsCalendar icsCalendar, CollectionId collectionId, Option<Instant> notModifiedSince);

    void moveCalendarEntry(UserInfo userInfo, String fileName, CollectionId from, CollectionId to);

    void removeCalendarEntry(UserInfo userInfo, String fileName, CollectionId collectionId);

    ListF<CalendarComponent> getCalendarEntries(
            UserInfo userInfo, CollectionId collectionId,
            CalendarComponentConditions eventConditions, CalendarComponentConditions todoConditions,
            ExportOptions options);

    ListF<ComponentGetResult> getCalendarEntries(
            UserInfo userInfo, CollectionId collectionId, ListF<String> fileNames, ExportOptions options);

    ListF<ComponentModified> getCalendarEntriesCreatedOrModifiedSince(
            UserInfo userInfo, CollectionId collectionId, Instant since, ExportOptions options);

    List<ComponentModified> getCalendarEntriesDeletedSince(
            UserInfo userInfo, CollectionId collectionId, Instant since);

}
