package ru.yandex.calendar.frontend.caldav.proto.facade;

import net.fortuna.ical4j.model.Component;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.frontend.caldav.proto.CTag;
import ru.yandex.calendar.frontend.caldav.proto.tree.CollectionId;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavSyncToken;

/**
 * @author Stepan Koltsov
 */
public class CalendarDescription {
    private final Option<String> owner;
    private final CollectionId collectionId;
    private final String name;
    private final IcalColor color;
    private final boolean writable;
    private final CTag ctag;
    private final Option<DavSyncToken> syncToken;
    private final ListF<String> supportedComponentNames;

    public CalendarDescription(
            Option<String> owner, CollectionId collectionId, String name,
            IcalColor color, boolean writable, ListF<String> supportedComponentNames,
            CTag ctag, Option<DavSyncToken> syncToken)
    {
        this.owner = owner;
        this.collectionId = collectionId;
        this.name = name;
        this.color = color;
        this.writable = writable;
        this.supportedComponentNames = supportedComponentNames;
        this.ctag = ctag;
        this.syncToken = syncToken;
    }

    public Option<String> getOwner() {
        return owner;
    }

    public CollectionId getCollectionId() {
        return collectionId;
    }

    public String getName() {
        return name;
    }

    public IcalColor getColor() {
        return color;
    }

    public boolean isWritable() {
        return writable;
    }

    public ListF<String> getSupportedComponentNames() {
        return supportedComponentNames;
    }

    public CTag getCtag() {
        return ctag;
    }

    public Option<DavSyncToken> getSyncToken() {
        return syncToken;
    }

    public boolean supportsVeventComponent() {
        return getSupportedComponentNames().containsTs(Component.VEVENT);
    }

    public static Function1B<CalendarDescription> writableF() {
        return new Function1B<CalendarDescription>() {
            public boolean apply(CalendarDescription a) {
                return a.writable;
            }
        };
    }

    public static Function1B<CalendarDescription> supportsVeventComponentF() {
        return new Function1B<CalendarDescription>() {
            public boolean apply(CalendarDescription d) {
                return d.supportsVeventComponent();
            }
        };
    }

} //~
