package ru.yandex.calendar.frontend.caldav.proto.facade;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.frontend.caldav.proto.ETag;
import ru.yandex.calendar.frontend.caldav.proto.PutResponse;
import ru.yandex.calendar.frontend.caldav.proto.caldav.report.CalendarComponentCondition;
import ru.yandex.calendar.frontend.caldav.proto.carddav.DirectoryCardData;
import ru.yandex.calendar.frontend.caldav.proto.carddav.report.CardComponentFilter;
import ru.yandex.calendar.logic.contact.directory.DirectoryType;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 * @author shinderuk
 * @see CaldavCalendarFacade
 * @see CcCalendarFacade
 */
public interface CarddavCalendarFacade {

    ListF<ContactEtag> getUserAddressbookContactEtags(PassportUid userUid, PassportUid clientUid);

    Tuple2List<String, Option<ContactVcard>> getUserAddressbookContactsByFileNames(PassportUid userUid,
                                                                                   ListF<String> fileNames,
                                                                                   PassportUid clientUid);
    /**
     * @see #getUserCalendarEvents(String, String, CalendarComponentCondition, String)
     */
    ListF<DirectoryCardData> getUserDirectoryContacts(CardComponentFilter cardComponentFilter, PassportUid clientUid);

    Option<DirectoryCardData> getUserDirectoryContact(String id, PassportUid clientUid);

    Option<DirectoryType> getUserDirectory(PassportUid clientUid);

    Option<ContactVcard> getUserAddressbookContact(PassportUid userUid, String fileName, PassportUid clientUid);

    PutResponse putUserAddressbookContact(PassportUid userUid, String fileName, Option<ETag> ifMatchEtag, byte[] vcf, PassportUid clientUid);

    void removeUserAddressbookCard(PassportUid userUid, String fileName, PassportUid clientUid);
} //~
