package ru.yandex.calendar.frontend.caldav.proto.facade;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestPrincipalPropertySearch;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusResponse2;
import ru.yandex.calendar.frontend.caldav.userAgent.UserAgentType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.ip.IpAddress;

/**
 * @author Stepan Koltsov
 * @see CaldavCalendarFacade
 * @see CarddavCalendarFacade
 */
public interface CcCalendarFacade {

    String getUserName(String user);

    CcUserInfo checkPassword(String user, String password, IpAddress userIp, String userAgent) throws AuthenticationFailedException;

    CcUserInfo checkOAuthToken(String token, IpAddress userIp, String userAgent) throws AuthenticationFailedException;

    ListF<MultiStatusResponse2> findUsers(ReportRequestPrincipalPropertySearch principalPropertySearch, PassportUid client, UserAgentType userAgent);

    boolean isUserResourcesAccessibleToClient(String user, String client);

} //~
