package ru.yandex.calendar.frontend.caldav.proto.facade;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class CcUserInfo {
    private final PassportUid uid;
    private final Email email;
    private final CcClientScope scope;

    public CcUserInfo(PassportUid uid, Email email, CcClientScope scope) {
        this.uid = uid;
        this.email = email;
        this.scope = scope;
    }

    public PassportUid getUid() {
        return uid;
    }

    public Email getEmail() {
        return email;
    }

    public CcClientScope getScope() {
        return scope;
    }

    public CcClient asCcClient() {
        return new CcClient(email.getEmail(), scope);
    }
}
