package ru.yandex.calendar.frontend.caldav.proto.facade;

import java.util.Optional;
import java.util.function.Function;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor(access = AccessLevel.PROTECTED)
@Getter
public class ComponentGetResult {
    private final String fileName;
    private final Optional<CalendarComponent> eventDescription;

    public static ComponentGetResult notFound(String fileName) {
        return new ComponentGetResult(fileName, Optional.empty());
    }

    public boolean isFound() {
        return eventDescription.isPresent();
    }

    public static Function<ComponentGetResult, CalendarComponent> getEventDescriptionF() {
        return r -> r.getEventDescription().get();
    }
}
