package ru.yandex.calendar.frontend.caldav.proto.facade;

import java.util.Optional;

import lombok.Getter;
import lombok.val;
import org.joda.time.Instant;

import ru.yandex.calendar.frontend.caldav.impl.EventEtag;

@Getter
public class ComponentModified extends ComponentGetResult {
    private final Instant date;

    private ComponentModified(String fileName, Optional<CalendarComponent> eventDescription, Instant date) {
        super(fileName, eventDescription);
        this.date = date;
    }

    public static ComponentModified found(CalendarComponent eventDescription) {
        val date = EventEtag.lastModifiedFromETag(eventDescription.getEtag());
        return new ComponentModified(eventDescription.getFileName(), Optional.of(eventDescription), date);
    }

    public static ComponentModified deleted(String filename, Instant deletionDate) {
        if (deletionDate == null) {
            throw new NullPointerException("deletionDate not set for " + filename);
        }
        return new ComponentModified(filename, Optional.empty(), deletionDate);
    }
}
