package ru.yandex.calendar.frontend.caldav.proto.facade;

import lombok.EqualsAndHashCode;
import lombok.Value;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.calendar.frontend.caldav.proto.ETag;
import ru.yandex.calendar.frontend.caldav.proto.tree.PropertiesCollectionBase;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.logic.ics.iv5j.vcard.VcfUtils;
import ru.yandex.misc.lang.Validate;

@Value
@EqualsAndHashCode(callSuper = false)
public final class ContactEtag extends PropertiesCollectionBase {
    String fileName;
    ETag etag;

    public ContactEtag(String fileName, ETag etag) {
        Validate.notEmpty(fileName);
        this.fileName = fileName;
        this.etag = etag;
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(ResourceType.DEFAULT_RESOURCE));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_GETETAG_PROP, etag.getValue()));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_GETCONTENTTYPE_PROP, VcfUtils.VCARD_CONTENT_TYPE));
        return ps;
    }
}
