package ru.yandex.calendar.frontend.caldav.proto.tree;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.Value;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;

import ru.yandex.calendar.frontend.caldav.userAgent.UserAgentType;
import ru.yandex.calendar.frontend.caldav.userAgent.UserAgents;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

@Value
public class CaldavRequestContext {
    CaldavContext caldavContext;
    DavServletRequest request;
    DavServletResponse response;
    MeterRegistry registry;

    public UserAgentType getUserAgentType() {
        return UserAgents.userAgentType(getUserAgent());
    }

    public String getUserAgent() {
        return HttpServletRequestX.wrap(request).getUserAgent().getOrElse("?");
    }
}
