package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavProperty;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.facade.CaldavCalendarFacade;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcCalendarFacade;

/**
 * @author Stepan Koltsov
 * @see CarddavResourceBase
 */
public abstract class CaldavResourceBase extends WebdavResourceBase implements CaldavResource {

    protected final CaldavCalendarFacade caldavCalendarFacade;
    protected final CcCalendarFacade ccCalendarFacade;

    protected CaldavResourceBase(CaldavRequestContext caldavRequestContext) {
        super(caldavRequestContext);
        this.caldavCalendarFacade = caldavRequestContext.getCaldavContext().getCaldavCalendarFacade();
        this.ccCalendarFacade = caldavRequestContext.getCaldavContext().getCcCalendarFacade();
    }

    @Override
    public boolean isAccessibleTo(String client) {
        return ClientHolder.getScope().includesCalendar();
    }

    @Override
    public void mkCalendar(ListF<DavProperty<?>> properties) throws DavException {
        throw unsupportedOperationException();
    }

} //~
