package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.HrefProperty;

import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 * @see CarddavResourceUserBase
 */
public abstract class CaldavResourceUserBase extends CaldavResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(CaldavResourceUserBase.class);

    protected final String user;
    protected final PassportUid passportUid;

    public CaldavResourceUserBase(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext);
        this.user = user;
        this.passportUid = passportUid;
    }

    protected String getUserName() {
        try {
            return ccCalendarFacade.getUserName(user);
        } catch (Exception e) {
            logger.warn("Failed to get user name", e);
            return "Unknown";
        }
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new HrefProperty(WebdavConstants.DAV_OWNER_PROP, CalendarUrls.principals(ClientHolder.get()).getEncoded(), false));
        return ps;
    }

    @Override
    public boolean isAccessibleTo(String client) {
        return super.isAccessibleTo(client) && ccCalendarFacade.isUserResourcesAccessibleToClient(user, client);
    }

    public String getUser() {
        return user;
    }

    public PassportUid getPassportUid() {
        return passportUid;
    }

} //~
