package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.facade.CalendarDescription;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class CaldavResourceUserEventsUser extends CaldavResourceUserBase {

    protected final CollectionId collectionId;

    public CaldavResourceUserEventsUser(CaldavRequestContext caldavContext, String user, String collectionId,
                                        PassportUid passportUid) {
        super(caldavContext, user, passportUid);
        this.collectionId = CollectionId.events(user, collectionId, passportUid);
    }

    @Override
    public String getHref() {
        return CalendarUrls.eventsUser(user, collectionId.getId()).getEncoded();
    }

    @Override
    public boolean exists() {
        return caldavCalendarFacade.existsCalendarWithId(collectionId);
    }

    @Override
    public final DavResource getCollection() {
        return new CaldavResourceUserEvents(caldavRequestContext, user, collectionId.getId(), collectionId.getPassportUid());
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[0]));
        CalendarDescription userCalendar = caldavCalendarFacade.getUserCalendar(ClientHolder.getPassportUid(), collectionId);
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_DISPLAYNAME_PROP, userCalendar.getName()));
        ps.add(new HrefProperty(WebdavConstants.DAV_PRINCIPAL_URL_PROP, getHref(), false));
        ps.add(new HrefProperty(CaldavConstants.CALDAV_USER_ADDRESS_SET_PROP, getHref(), false));
        return ps;
    }

} //~
