package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.caldav.report.ReportRequestCalendarQuery;
import ru.yandex.calendar.frontend.caldav.proto.jackrabbit.JackrabbitUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestParser;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusUtils;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class CaldavResourceUserInbox extends CaldavResourceUserChildBase {
    @Autowired
    private MultiStatusUtils multiStatusUtils;

    public CaldavResourceUserInbox(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext, user, passportUid);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public DavResourceIterator getMembers() {
        // XXX: add some
        return DavResourceIteratorImpl.EMPTY;
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[] { WebdavConstants.DAV_COLLECTION_RT, CaldavConstants.CALDAV_SCHEDULE_INBOX_RT }));

        Option<Long> layerId = caldavCalendarFacade.getDefaultUserLayerId(passportUid);
        if (layerId.isPresent()) {
            ps.add(new HrefProperty(CaldavConstants.CALDAV_SCHEDULE_DEFAULT_CALENDAR_URL_PROP,
                    CalendarUrls.events(user, Long.toString(layerId.get())).getEncoded(), false));
        }
        return ps;
    }

    @Override
    public String getHref() {
        return CalendarUrls.inbox(user).getEncoded();
    }

    /**
     * @see CaldavResourceUserEvents#report(WebdavRequest, WebdavResponse)
     */
    @Override
    public void report(WebdavRequest request, WebdavResponse response) throws DavException, IOException {
        ReportRequest reportRequest = ReportRequestParser.parse(request.getRequestDocument().getDocumentElement());
        if (reportRequest instanceof ReportRequestCalendarQuery) {
            ReportRequestCalendarQuery calendarQuery = (ReportRequestCalendarQuery) reportRequest;
            reportQuery(calendarQuery, request, response);
        } else {
            response.sendError(JackrabbitUtils.supportedReportError());
        }
    }

    private void reportQuery(ReportRequestCalendarQuery query, WebdavRequest request, WebdavResponse response) {
        // XXX: add some

        MultiStatus ms = JackrabbitUtils.makeMultiStatus(Cf.list(), query.getPropertiesRequest());

        multiStatusUtils.sendMultiStatus(ms, request, response, getMeterRegistry());
    }

} //~
