package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavRequest;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.ScheduleResponse;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox.OutboxRequest;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox.OutboxRequestVEvent;
import ru.yandex.calendar.frontend.caldav.proto.caldav.schedule.outbox.OutboxRequestVFreeBusy;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.xml.dom4j.Dom4jUtils;

/**
 * @author Stepan Koltsov
 */
public class CaldavResourceUserOutbox extends CaldavResourceUserChildBase {

    public CaldavResourceUserOutbox(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext, user, passportUid);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public DavResourceIterator getMembers() {
        return DavResourceIteratorImpl.EMPTY;
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[] { WebdavConstants.DAV_COLLECTION_RT, CaldavConstants.CALDAV_SCHEDULE_OUTBOX_RT }));
        return ps;
    }

    @Override
    public String getHref() {
        return CalendarUrls.outbox(user).getEncoded();
    }

    @Override
    public void post(WebdavRequest request, WebdavResponse response) throws DavException, IOException {
        // http://wiki.yandex-team.ru/Calendar/CalDAV/1/vfreebusy

        IcsCalendar calendar = IcsCalendar.parse(request.getInputStream());

        OutboxRequest req = OutboxRequest.parse(calendar);

        CaldavRequest caldavRequest = new CaldavRequest(request);

        if (req instanceof OutboxRequestVFreeBusy) {
            freeBusy(caldavRequest, response, (OutboxRequestVFreeBusy) req);
        } else if (req instanceof OutboxRequestVEvent) {
            event(caldavRequest, response, (OutboxRequestVEvent) req);
        } else {
            throw new IllegalArgumentException("unknown req: " + req);
        }
    }

    private void event(CaldavRequest request, WebdavResponse response, OutboxRequestVEvent vevent) throws DavException, IOException {
        // http://wiki.yandex-team.ru/calendar/caldav/1/google/outbox-post-attendee

        // Probably http://tools.ietf.org/html/draft-desruisseaux-ischedule-01#appendix-A.1
        // (it uses different namespace)
        // Haven't found proper specification.

        ScheduleResponse r = caldavCalendarFacade.notifyAttendees(passportUid, vevent, ClientHolder.getPassportUid(), request.getRecipients());

        Dom4jUtils.write(r.toXml(), response.getOutputStream());
    }

    private void freeBusy(CaldavRequest request, WebdavResponse response, OutboxRequestVFreeBusy freeBusy) throws DavException, IOException {
        // http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-08#section-14.1
        // http://tools.ietf.org/html/draft-desruisseaux-caldav-sched-08#appendix-B.5

        ScheduleResponse element = caldavCalendarFacade.getFreeBusy(passportUid, freeBusy, ClientHolder.getPassportUid());

        response.setContentType("application/xml; charset=utf-8");
        Dom4jUtils.write(element.toXml(), response.getOutputStream());
    }

} //~
