package ru.yandex.calendar.frontend.caldav.proto.tree;

import net.fortuna.ical4j.model.Component;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavSupportedCalendarComponentSets;
import ru.yandex.calendar.frontend.caldav.proto.ccdav.CcDavUtils;
import ru.yandex.calendar.frontend.caldav.proto.facade.CalendarDescription;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.SupportedReportSetProperty;
import ru.yandex.calendar.frontend.caldav.userAgent.UserAgentType;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class CaldavResourceUserRoot extends CaldavResourceUserBase {

    public CaldavResourceUserRoot(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext, user, passportUid);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public String getHref() {
        return CalendarUrls.calendarsRoot(user).getEncoded();
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = super.getProperties();
        ps.add(new ResourceType(ResourceType.COLLECTION));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_DISPLAYNAME_PROP, getUserName()));
        ps.add(new SupportedReportSetProperty(CcDavUtils.getSupportedReports()));
        ps.add(new DefaultDavProperty<>(
                WebdavConstants.DAV_SYNC_TOKEN_PROP, caldavCalendarFacade.getUserSyncToken(getPassportUid()).getValue()));
        // CAL-6744
        ps.add(new CaldavSupportedCalendarComponentSets(Cf.list(Cf.list(Component.VTODO), Cf.list(Component.VEVENT))));

        return ps;
    }

    @Override
    public void removeMember(DavResource member) throws DavException {
        if (member instanceof CaldavResourceUserCalendarBase) {
            CaldavResourceUserCalendarBase calendar = (CaldavResourceUserCalendarBase) member;
            caldavCalendarFacade.removeCalendar(ClientHolder.getPassportUid(), calendar.getCollectionId());
        } else {
            throw new DavException(403, "not allowed to delete calendar " + member.getHref());
        }
    }

    @Override
    public DavResourceIterator getMembers() {
        //CaldavResourceUserUser userUser = new CaldavResourceUserUser(caldavContext, user);
        final PassportUid client = ClientHolder.getPassportUid();
        CaldavResourceUserInbox inbox = new CaldavResourceUserInbox(caldavRequestContext, user, client);
        CaldavResourceUserOutbox outbox = new CaldavResourceUserOutbox(caldavRequestContext, user, client);

        ListF<CalendarDescription> calendars;
        if (client.equalsTs(passportUid)) {
            calendars = caldavCalendarFacade.getUserOwnCalendars(passportUid)
                    .plus(caldavCalendarFacade.getUserVisibleExternalCalendars(passportUid));
        } else {
            calendars = caldavCalendarFacade.getUserOwnCalendarsSharedToClient(passportUid, ClientHolder.getPassportUid());
        }

        if (caldavRequestContext.getUserAgentType() == UserAgentType.CALDAVSYNCADAPTER_ANDROID) {
            calendars = calendars.filter(CalendarDescription.supportsVeventComponentF()); // CAL-6600
        }

        ListF<DavResource> list = Cf.<DavResource>list(inbox, outbox).plus(
                calendars.map((Function<CalendarDescription, CaldavResourceBase>) a -> {
                    if (a.getCollectionId().isEvents()) {
                        return new CaldavResourceUserEvents(caldavRequestContext, user, a.getCollectionId().getId(),
                                a.getCollectionId().getPassportUid());
                    } else if (a.getCollectionId().isTodos()) {
                        return new CaldavResourceUserTodos(caldavRequestContext, user,
                                a.getCollectionId().getId(), a.getCollectionId().getPassportUid());
                    } else {
                        return new CaldavResourceUserUnknown(caldavRequestContext, user, a.getCollectionId().getId(),
                                a.getCollectionId().getPassportUid());
                    }
                }));
        return new DavResourceIteratorImpl(list);
    }

} //~
