package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavResource;

import ru.yandex.inside.passport.PassportUid;

/**
 * @author Daniel Brylev
 */
public class CaldavResourceUserTodosEntry extends CaldavResourceUserCalendarEntryBase {

    public CaldavResourceUserTodosEntry(
            CaldavRequestContext caldavContext, String user, String collectionId, String name,
            PassportUid passportUid) {
        super(caldavContext, CollectionId.todos(user, collectionId, passportUid), name);
    }

    @Override
    public String getHref() {
        return CalendarUrls.todo(getUser(), getCollectionId().getId(), getName()).getEncoded();
    }

    @Override
    public DavResource getCollection() {
        return new CaldavResourceUserTodos(caldavRequestContext, getUser(), getCollectionId().getId(),
                getCollectionId().getPassportUid());
    }
}
