package ru.yandex.calendar.frontend.caldav.proto.tree;


import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavSupportedCalendarComponentSet;
import ru.yandex.calendar.frontend.caldav.proto.facade.CalendarProperties;
import ru.yandex.calendar.frontend.caldav.proto.facade.IcalColor;
import ru.yandex.calendar.frontend.caldav.proto.facade.IcalColorUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Stepan Koltsov
 * @author shinderuk
 */
public class CaldavResourceUserUnknown extends CaldavResourceUserCalendarBase {

    public CaldavResourceUserUnknown(CaldavRequestContext caldavContext, String user, String id, PassportUid passportUid) {
        super(caldavContext, CollectionId.unknown(user, id, passportUid));
    }

    @Override
    public String getHref() {
        return CalendarUrls.unknown(getUser(), getCollectionId().getId()).getEncoded();
    }

    @Override
    public void mkCalendar(ListF<DavProperty<?>> properties) throws DavException {
        PassportUid clientPassportUid = ClientHolder.getPassportUid();
        if (!clientPassportUid.equalsTs(passportUid)) {
            throw new DavException(HttpStatus.SC_403_FORBIDDEN);
        }

        Option<String> displayName = Option.empty();
        Option<IcalColor> color = Option.empty();
        Option<Boolean> affectsAvailability = Option.empty();

        ListF<String> supportedComponentNames = Cf.list();

        for (DavProperty<?> prop : properties) {
            DavPropertyName propName = prop.getName();
            if (propName.equals(WebdavConstants.DAV_DISPLAYNAME_PROP)) {
                displayName = Option.of(prop.getValue().toString());
            } else if (propName.equals(CaldavConstants.CALENDAR_COLOR_PROP)) {
                IcalColor icalColor = IcalColorUtils.parseDavProperty(prop.getValue().toString());
                color = Option.of(icalColor);
            } else if (prop instanceof CaldavSupportedCalendarComponentSet) {
                supportedComponentNames = ((CaldavSupportedCalendarComponentSet) prop).getComponentNames();
            } else if (propName.equals(CaldavConstants.CALDAV_SCHEDULE_CALENDAR_TRANSP)) {
                boolean isOpaque = !prop.getValue().toString().contains("transparent");
                affectsAvailability = Option.of(isOpaque);
            }
         }

        caldavCalendarFacade.makeCalendar(getPassportUid(), getCollectionId().getId(),
                supportedComponentNames, new CalendarProperties(displayName, color, affectsAvailability));
    }

} //~
