package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavResource;

import ru.yandex.inside.passport.PassportUid;

/**
 * @author Daniel Brylev
 */
public class CaldavResourceUserUnknownEntry extends CaldavResourceUserCalendarEntryBase {

    public CaldavResourceUserUnknownEntry(
            CaldavRequestContext caldavContext, String user, String collectionId, String name, PassportUid passportUid)
    {
        super(caldavContext, CollectionId.unknown(user, collectionId, passportUid), name);
    }

    @Override
    public String getHref() {
        return CalendarUrls.unknownEntry(getUser(), getCollectionId().getId(), getName()).getEncoded();
    }

    @Override
    public DavResource getCollection() {
        return new CaldavResourceUserUnknown(caldavRequestContext, getUser(), getCollectionId().getId(),
                getCollectionId().getPassportUid());
    }
}
