package ru.yandex.calendar.frontend.caldav.proto.tree;

import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.facade.CarddavCalendarFacade;
import ru.yandex.calendar.frontend.caldav.proto.facade.CcCalendarFacade;

/**
 * @author Stepan Koltsov
 * @see CaldavResourceBase
 */
public abstract class CarddavResourceBase extends WebdavResourceBase {

    protected final CarddavCalendarFacade carddavCalendarFacade;
    protected final CcCalendarFacade ccCalendarFacade;

    protected CarddavResourceBase(CaldavRequestContext caldavContext) {
        super(caldavContext);
        this.carddavCalendarFacade = caldavContext.getCaldavContext().getCarddavCalendarFacade();
        this.ccCalendarFacade = caldavContext.getCaldavContext().getCcCalendarFacade();
    }

    @Override
    public boolean isAccessibleTo(String client) {
        return ClientHolder.getScope().includesContacts();
    }
} //~
