package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.dom4j.QName;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.carddav.DirectoryCardData;
import ru.yandex.calendar.frontend.caldav.proto.carddav.report.ReportRequestAddressbookQuery;
import ru.yandex.calendar.frontend.caldav.proto.jackrabbit.JackrabbitUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestParser;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.SupportedReportSetProperty;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusUtils;
import ru.yandex.calendar.logic.contact.directory.DirectoryType;

/**
 * @author Stepan Koltsov
 */
public class CarddavResourceDirectory extends CarddavResourceBase {
    @Autowired
    private MultiStatusUtils multiStatusUtils;

    public CarddavResourceDirectory(CaldavRequestContext caldavContext) {
        super(caldavContext);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean exists() {
        return carddavCalendarFacade.getUserDirectory(ClientHolder.getPassportUid()).isPresent();
    }

    @Override
    public DavPropertySet getProperties() {
        DirectoryType directory = carddavCalendarFacade.getUserDirectory(ClientHolder.getPassportUid()).get();
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[] { ResourceType.COLLECTION, CarddavConstants.CARDDAV_DIRECTORY_RT, CarddavConstants.CARDDAV_ADDRESSBOOK_RT }));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_DISPLAYNAME_PROP, directory.getDisplayName()));
        ps.add(new CurrentUserPrivilegeSetProperty(new Privilege[] { Privilege.PRIVILEGE_READ }));
        ps.add(new SupportedReportSetProperty(new QName[] { CarddavConstants.CARDDAV_ADDRESSBOOK_QUERY_QNAME }));
        return ps;
    }

    @Override
    public String getHref() {
        return CalendarUrls.directory().getEncoded();
    }

    @Override
    public DavResourceIterator getMembers() {
        return DavResourceIteratorImpl.EMPTY;
    }

    @Override
    public void report(WebdavRequest request, WebdavResponse response) throws DavException, IOException {
        ReportRequest reportRequest = ReportRequestParser.parse(request.getRequestDocument().getDocumentElement());
        if (reportRequest instanceof ReportRequestAddressbookQuery) {
            // XXX: implement multistatus without jackrabbit

            ReportRequestAddressbookQuery addressbookQuery = (ReportRequestAddressbookQuery) reportRequest;

            ListF<DirectoryCardData> contacts = carddavCalendarFacade.getUserDirectoryContacts(
                    addressbookQuery.getCardComponentFilter(), ClientHolder.getPassportUid());

            ListF<DavResource> contactResources = contacts.map(contact -> {
                CarddavResourceDirectoryContact r =
                        new CarddavResourceDirectoryContact(caldavRequestContext, contact.getId());
                r.setDirectoryCardData(contact);
                return r;
            });

            MultiStatus ms = JackrabbitUtils.makeMultiStatus(contactResources, addressbookQuery.getPropertiesRequest());
            multiStatusUtils.sendMultiStatus(ms, request, response, getMeterRegistry());
        } else {
            response.sendError(JackrabbitUtils.supportedReportError());
        }
    }

} //~
