package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import javax.annotation.Nullable;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.carddav.DirectoryCardData;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.logic.ics.iv5j.vcard.VcfUtils;

/**
 * @author Stepan Koltsov
 */
public class CarddavResourceDirectoryContact extends CarddavResourceBase {

    private final String id;

    @Nullable
    private transient Option<DirectoryCardData> directoryCardData;

    public CarddavResourceDirectoryContact(CaldavRequestContext caldavContext, String id) {
        super(caldavContext);
        this.id = id;
    }

    @Override
    public DavResource getCollection() {
        return new CarddavResourceDirectory(caldavRequestContext);
    }

    public void setDirectoryCardData(DirectoryCardData directoryCardData) {
        this.directoryCardData = Option.of(directoryCardData);
    }

    private Option<DirectoryCardData> getDirectoryCardData() {
        if (directoryCardData == null) {
            directoryCardData = carddavCalendarFacade.getUserDirectoryContact(id, ClientHolder.getPassportUid());
        }
        return directoryCardData;
    }

    @Override
    public boolean exists() {
        return getDirectoryCardData().isPresent();
    }

    @Override
    public void spool(OutputContext outputContext) throws IOException {
        DirectoryCardData card = getDirectoryCardData().get();
        outputContext.setETag(card.getEtag().getValue());

        if (outputContext.hasStream()) {
            outputContext.setContentType(VcfUtils.VCARD_CONTENT_TYPE);
            outputContext.getOutputStream().write(card.getVcf().serializeToBytes());
        }
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new DefaultDavProperty<String>(WebdavConstants.DAV_GETETAG_PROP, getDirectoryCardData().get().getEtag().getValue()));
        ps.add(new DefaultDavProperty<String>(CarddavConstants.CARDDAV_ADDRESS_DATA_PROP, getDirectoryCardData().get().getVcf().serialize()));
        return ps;
    }

    @Override
    public DavPropertyName[] getPropertyNames() {
        return new DavPropertyName[] {
                WebdavConstants.DAV_GETETAG_PROP,
                CarddavConstants.CARDDAV_ADDRESS_DATA_PROP,
        };
    }

    @Override
    public String getHref() {
        return CalendarUrls.directoryContact(id).getEncoded();
    }

} //~
