package ru.yandex.calendar.frontend.caldav.proto.tree;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.bolts.collection.Cf;

/**
 * Hacked directory resource for iOS 4.3.X that expects the nested directories inside directory gateway
 *
 * @author Daniel Brylev <dbrylev@yandex-team.ru>
 */
public class CarddavResourceDirectoryGhost extends CarddavResourceDirectory {

    private final boolean nested;

    public CarddavResourceDirectoryGhost(CaldavRequestContext caldavContext, boolean nested) {
        super(caldavContext);
        this.nested = nested;
    }

    @Override
    public boolean isCollection() {
        return !nested || super.isCollection();
    }

    @Override
    public DavPropertySet getProperties() {
        if (!nested) {
            DavPropertySet ps = new DavPropertySet();
            ps.add(new ResourceType(new int[] { ResourceType.COLLECTION }));
            return ps;
        }
        return super.getProperties();
    }

    @Override
    public String getHref() {
        return !nested ? super.getHref() : CalendarUrls.directoryContact("x/").getDecoded();
    }

    @Override
    public DavResourceIterator getMembers() {
        if (!nested) {
            return new DavResourceIteratorImpl(
                    Cf.<DavResource>list(new CarddavResourceDirectoryGhost(caldavRequestContext, true)));
        }
        return super.getMembers();
    }

}
