package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;
import java.io.PrintWriter;

import org.apache.commons.lang.NotImplementedException;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.PutResponse;
import ru.yandex.calendar.frontend.caldav.proto.caldav.CaldavConstants;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.carddav.report.ReportRequestAddressbookMultiget;
import ru.yandex.calendar.frontend.caldav.proto.ccdav.CcDavUtils;
import ru.yandex.calendar.frontend.caldav.proto.facade.ContactEtag;
import ru.yandex.calendar.frontend.caldav.proto.facade.ContactVcard;
import ru.yandex.calendar.frontend.caldav.proto.jackrabbit.JackrabbitUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.DavHref;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.PropertiesRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequest;
import ru.yandex.calendar.frontend.caldav.proto.webdav.report.ReportRequestParser;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatus2;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusResponse2;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.MultiStatusUtils;
import ru.yandex.calendar.frontend.caldav.proto.webdav.xml.PropStat;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 * @author shinderuk
 * @see CaldavResourceUserEvents
 */
public class CarddavResourceUserAddressbook extends CarddavResourceUserBase {
    private static final Logger logger = LoggerFactory.getLogger(CarddavResourceUserAddressbook.class);

    protected CarddavResourceUserAddressbook(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext, user, passportUid);
    }

    @Override
    public String getHref() {
        return CalendarUrls.addressbooksUserAddressbook(user).getEncoded();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public DavResourceIterator getMembers() {
        throw new NotImplementedException("not needed");
    }

    /**
     * @see CaldavResourceUserEvents#removeMember(DavResource)
     */
    @Override
    public void removeMember(DavResource member) throws DavException {
        CarddavResourceUserAddressbookCard card = (CarddavResourceUserAddressbookCard) member;
        carddavCalendarFacade.removeUserAddressbookCard(passportUid, card.getName(), ClientHolder.getPassportUid());
    }

    @Override
    public DavPropertySet getProperties() {
        DavPropertySet ps = new DavPropertySet();
        ps.add(new ResourceType(new int[]{ResourceType.COLLECTION, CarddavConstants.CARDDAV_ADDRESSBOOK_RT}));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_DISPLAYNAME_PROP, getUserName()));
        ps.add(new DefaultDavProperty<>(CaldavConstants.CALENDARSERVER_GETCTAG_PROP, String.valueOf(System.currentTimeMillis())));
        ps.add(new DefaultDavProperty<>(WebdavConstants.DAV_GETETAG_PROP, String.valueOf(System.currentTimeMillis())));
        ps.add(new CurrentUserPrivilegeSetProperty(new Privilege[] { Privilege.PRIVILEGE_READ, Privilege.PRIVILEGE_WRITE }));
        return ps;
    }

    @Override
    public PutResponse put(WebdavResource resource0, InputContext inputContext) throws DavException {
        CarddavResourceUserAddressbookCard resource = (CarddavResourceUserAddressbookCard) resource0;
        return carddavCalendarFacade.putUserAddressbookContact(
                passportUid, resource.getName(), CcDavUtils.getIfMatchETag(inputContext),
                new InputStreamX(inputContext.getInputStream()).readBytes(), ClientHolder.getPassportUid());
    }

    @Override
    protected ListF<MultiStatusResponse2> propFindChildren(final PropertiesRequest request, int depth) {
        ListF<ContactEtag> contactEtags = carddavCalendarFacade.getUserAddressbookContactEtags(passportUid, ClientHolder.getPassportUid());

        return contactEtags.map(contactEtag -> MultiStatusResponse2.propStatResponse(getContactHref(contactEtag.getFileName()),
                JackrabbitUtils.getProperties(contactEtag, request)));
    }

    private DavHref getContactHref(String filename) {
        DavHref href = DavHref.fromEncoded(getHref());
        return href.addDecodedChild(filename);
    }

    /**
     * @see CaldavResourceUserEvents#report(WebdavRequest, WebdavResponse)
     */
    @Override
    public void report(WebdavRequest request, WebdavResponse response) throws DavException, IOException {
        Document doc = request.getRequestDocument();
        Element root = doc.getDocumentElement();

        ReportRequest reportRequest = ReportRequestParser.parse(root);

        logger.debug("Report req: " + reportRequest);

        if (reportRequest instanceof ReportRequestAddressbookMultiget) {
            ReportRequestAddressbookMultiget multiget = (ReportRequestAddressbookMultiget) reportRequest;

            ListF<String> fileNames = multiget.getHrefs().map(contactFileNameF());
            Tuple2List<String, Option<ContactVcard>> contacts =
                    carddavCalendarFacade.getUserAddressbookContactsByFileNames(passportUid, fileNames, ClientHolder.getPassportUid());

            ListF<DavHref> code404Hrefs = Cf.arrayList();
            ListF<MultiStatusResponse2> foundResponses = Cf.arrayList();

            for (Tuple2<String, Option<ContactVcard>> t : contacts) {
                DavHref href = CalendarUrls.addressbookUserAddressbookCard(user, t._1);
                Option<ContactVcard> contact = t._2;

                if (contact.isPresent()) {
                    ListF<PropStat> propStats = JackrabbitUtils.getProperties(contact.get(),
                            multiget.getPropertiesRequest());
                    foundResponses.add(MultiStatusResponse2.propStatResponse(href, propStats));
                } else {
                    code404Hrefs.add(href);
                }
            }

            ListF<MultiStatusResponse2> responses = foundResponses;
            if (code404Hrefs.isNotEmpty()) {
                responses.addAll(code404Hrefs.map(MultiStatusResponse2.hrefResponseF(HttpStatus.SC_404_NOT_FOUND)));
            }

            MultiStatus2 ms = new MultiStatus2(responses);
            MultiStatusUtils.sendMultiStatus(ms, request, response, getMeterRegistry());

        } else {
            response.sendError(JackrabbitUtils.supportedReportError());
        }
    }

    private Function<DavHref, String> contactFileNameF() {
        final String parentHref = DavHref.fromEncoded(getHref()).getDecoded();
        return href -> StringUtils.removeStart(href.getDecoded(), parentHref);
    }

    @Override
    public boolean hasCustomGet() {
        return true;
    }

    @Override
    public void get(WebdavRequest request, WebdavResponse response) throws IOException {
        String op = StringUtils.defaultIfEmpty(request.getParameter("op"), "");

        if (op.equals("ls")) {
            ListF<JsonValue> list = Cf.linkedList();
            ListF<ContactEtag> contactEtags = carddavCalendarFacade.getUserAddressbookContactEtags(
                    passportUid, ClientHolder.getPassportUid());

            for (ContactEtag contactEtag : contactEtags) {
                list.add(new JsonObject(Tuple2List.<String, JsonValue>tuple2List()
                        .plus1("fileName", JsonString.valueOf(contactEtag.getFileName()))
                        .plus1("etag", JsonString.valueOf(contactEtag.getEtag().getValue()))));
            }

            JsonObject r = new JsonObject(Tuple2List.<String, JsonValue>tuple2List()
                    .plus1("list", new JsonArray(list)));

            response.setContentType("application/json; charset=utf-8");
            PrintWriter writer = response.getWriter();
            writer.println(r.serialize());
        } else {
            response.setContentType("text/plain; charset=utf-8");
            PrintWriter writer = response.getWriter();
            writer.println("addressbook");
            writer.println("operations:");
            writer.println("GET " + getHref() + "?op=ls");
            writer.println("POST " + getHref() + "?op=multiget");
        }
    }

} //~
