package ru.yandex.calendar.frontend.caldav.proto.tree;

import java.io.IOException;

import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.WebdavUtils;
import ru.yandex.calendar.frontend.caldav.proto.ClientHolder;
import ru.yandex.calendar.frontend.caldav.proto.ETag;
import ru.yandex.calendar.frontend.caldav.proto.carddav.CarddavConstants;
import ru.yandex.calendar.frontend.caldav.proto.facade.ContactVcard;
import ru.yandex.calendar.frontend.caldav.proto.webdav.WebdavConstants;
import ru.yandex.calendar.logic.ics.iv5j.vcard.VcfUtils;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.CharsetUtils;


/**
 * @author Stepan Koltsov
 * @author shinderuk
 * @see CaldavResourceUserCalendarEntryBase
 */
public class CarddavResourceUserAddressbookCard extends CarddavResourceUserBase {

    private final String name;
    private final Option<ContactVcard> contact;

    protected CarddavResourceUserAddressbookCard(CaldavRequestContext caldavContext, String user, String name,
                                                 PassportUid passportUid) {
        super(caldavContext, user, passportUid);
        this.name = name;
        this.contact = carddavCalendarFacade.getUserAddressbookContact(passportUid, name, ClientHolder.getPassportUid());
    }

    public String getName() {
        return name;
    }

    @Override
    public String getHref() {
        return CalendarUrls.addressbookUserAddressbookCard(user, name).getEncoded();
    }

    @Override
    public final DavResource getCollection() {
        return new CarddavResourceUserAddressbook(caldavRequestContext, user, passportUid);
    }

    private ETag getEtag() {
        return contact.get().getEtag();
    }

    @Override
    public boolean exists() {
        return contact.isPresent();
    }

    private byte[] getVcardData() {
        return contact.get().getVcard().serializeToBytes();
    }

    /**
     * @see CaldavResourceUserCalendarEntryBase#spool(OutputContext)
     */
    @Override
    public void spool(OutputContext outputContext) throws IOException {
        outputContext.setETag(getEtag().getValue());
        if (outputContext.hasStream()) {
            outputContext.setContentType(VcfUtils.VCARD_CONTENT_TYPE);
            outputContext.getOutputStream().write(getVcardData());
        }
    }

    /**
     * @see CaldavResourceUserCalendarEntryBase#getPropertyNames()
     */
    @Override
    public DavPropertyName[] getPropertyNames() {
        return new DavPropertyName[] {
                WebdavConstants.DAV_RESOURCETYPE_PROP,
                WebdavConstants.DAV_GETETAG_PROP,
                WebdavConstants.DAV_GETCONTENTTYPE_PROP,
                CarddavConstants.CARDDAV_ADDRESS_DATA_PROP,
        };
    }

    /**
     * @see CaldavResourceUserCalendarEntryBase#getProperty(DavPropertyName)
     */
    @Override
    public DavProperty<?> getProperty(DavPropertyName name) {
        if (name.equals(WebdavConstants.DAV_RESOURCETYPE_PROP)) {
            return new ResourceType(new int[0]);
        } else if (name.equals(WebdavConstants.DAV_GETETAG_PROP)) {
            return new DefaultDavProperty<>(WebdavConstants.DAV_GETETAG_PROP, getEtag().getValue());
        } else if (name.equals(WebdavConstants.DAV_GETCONTENTTYPE_PROP)) {
            return new DefaultDavProperty<>(WebdavConstants.DAV_GETETAG_PROP, VcfUtils.VCARD_CONTENT_TYPE);
        } else if (name.equals(CarddavConstants.CARDDAV_ADDRESS_DATA_PROP)) {
            return new DefaultDavProperty<>(CarddavConstants.CARDDAV_ADDRESS_DATA_PROP, CharsetUtils.decodeUtf8(getVcardData()));
        } else {
            return null;
        }
    }

    /**
     * @see CaldavResourceUserCalendarEntryBase#getProperties()
     */
    @Override
    public DavPropertySet getProperties() {
        return WebdavUtils.getPropertiesFromNames(this);
    }

} //~
