package ru.yandex.calendar.frontend.caldav.proto.tree;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 * @see CaldavResourceUserBase
 */
public abstract class CarddavResourceUserBase extends CarddavResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(CarddavResourceUserBase.class);

    protected final String user;
    protected final PassportUid passportUid;

    protected CarddavResourceUserBase(CaldavRequestContext caldavContext, String user, PassportUid passportUid) {
        super(caldavContext);
        this.user = user;
        this.passportUid = passportUid;
    }

    protected String getUserName() {
        try {
            return ccCalendarFacade.getUserName(user);
        } catch (Exception e) {
            logger.warn("Failed to get user name", e);
            return "Unknown";
        }
    }

    @Override
    public boolean isAccessibleTo(String client) {
        return super.isAccessibleTo(client) && ccCalendarFacade.isUserResourcesAccessibleToClient(user, client);
    }
} //~
